## Selection and Side Layout


### Simple Side Layout

```Python 
from tensorpc.flow import mui, three, plus, appctx, mark_create_layout, flowui
class App:
    
    class Config(plus.AppInMemory.Config):
        is_horizontal = False
        height = "800px"

    @mark_create_layout
    def my_layout(self):
        nodes = [
            flowui.Node(id="1", type="default", data=flowui.NodeData(label="Node 1"), position=flowui.XYPosition(0, 0)),
            flowui.Node(id="2", type="default", data=flowui.NodeData(label="Node 2"), position=flowui.XYPosition(0, 100)),

        ]
        graph = flowui.Flow(nodes, [], [
            flowui.MiniMap(),
            flowui.Controls(),
            flowui.Background()
        ])
        self.graph = graph
        self.side_container = mui.Fragment([])
        self.graph.event_selection_change.on(self._on_selection)
        return mui.HBox([
            mui.HBox([
                graph,
            ]).prop(flex=2),
            self.side_container,

        ]).prop(width="100%", height="100%", overflow="hidden")

    async def _on_selection(self, selection: flowui.EventSelection):
        if selection.nodes:
            node =  self.graph.get_node_by_id(selection.nodes[0])
            print(node)
            await self.side_container.set_new_layout([
                mui.VBox([
                    mui.Typography(f"Node {node.id}"),
                    mui.Typography(f"Label: {node.data.label}"),
                    mui.Typography(f"Type: {node.type}"),
                ]).prop(flex=1)
            ])
        else:
            await self.side_container.set_new_layout([])

    
```

### Side Layout With Allotment

```Python 
from tensorpc.flow import mui, three, plus, appctx, mark_create_layout, flowui
class App:
    
    class Config(plus.AppInMemory.Config):
        is_horizontal = False
        height = "800px"

    @mark_create_layout
    def my_layout(self):
        nodes = [
            flowui.Node(id="1", type="default", data=flowui.NodeData(label="Node 1"), position=flowui.XYPosition(0, 0)),
            flowui.Node(id="2", type="default", data=flowui.NodeData(label="Node 2"), position=flowui.XYPosition(0, 100)),

        ]
        graph = flowui.Flow(nodes, [], [
            flowui.MiniMap(),
            flowui.Controls(),
            flowui.Background()
        ])
        self.graph = graph
        self.side_container = mui.Fragment([])
        self.graph.event_selection_change.on(self._on_selection)
        self.global_container = mui.Allotment(mui.Allotment.ChildDef([
            mui.Allotment.Pane(graph),
            mui.Allotment.Pane(self.side_container, visible=False),
        ])).prop(defaultSizes=[200, 100])
        return mui.HBox([
            self.global_container
        ]).prop(width="100%", height="100%", overflow="hidden")

    async def _on_selection(self, selection: flowui.EventSelection):
        if selection.nodes:
            node =  self.graph.get_node_by_id(selection.nodes[0])
            await self.side_container.set_new_layout([
                mui.VBox([
                    mui.Typography(f"Node {node.id}"),
                    mui.Typography(f"Label: {node.data.label}"),
                    mui.Typography(f"Type: {node.type}"),
                ]).prop(flex=1)
            ])
            await self.global_container.update_pane_props(1, {
                "visible": True
            })
        else:
            await self.side_container.set_new_layout([])
            await self.global_container.update_pane_props(1, {
                "visible": False
            })
```
